# Guide d'Installation - mda Talkbox v1.0.1

## 📦 Contenu du Package

Vous avez reçu **mdaTalkbox-AppleSilicon-v1.0.1.pkg**, un plugin AudioUnit optimisé pour Mac Apple Silicon (M1/M2/M3) et Intel.

## ✨ Nouveautés de cette Version

Cette version corrige le problème de **son étouffé** qui affectait les Mac Apple Silicon :
- ✅ Son clair et riche en fréquences
- ✅ Présence vocale restaurée
- ✅ Qualité audio identique aux Mac Intel
- ✅ Pas de crépitements
- ✅ Compatible Universal Binary (ARM64 + x86_64)

---

## 🔧 Installation

### Étape 1 : Télécharger le Package
Si vous recevez le fichier par AirDrop ou téléchargement, placez-le sur votre Bureau ou dans Téléchargements.

### Étape 2 : Autoriser l'Installation
macOS peut bloquer les packages non signés :

1. **Si vous voyez un avertissement de sécurité :**
   - Allez dans **Préférences Système** > **Confidentialité et sécurité**
   - Descendez jusqu'à voir le message concernant mdaTalkbox
   - Cliquez sur **Ouvrir quand même**

2. **Alternative :**
   ```bash
   # Ouvrir le Terminal et taper :
   xattr -d com.apple.quarantine ~/Desktop/mdaTalkbox-AppleSilicon-v1.0.1.pkg
   ```

### Étape 3 : Lancer l'Installeur
1. Double-cliquez sur **mdaTalkbox-AppleSilicon-v1.0.1.pkg**
2. Suivez les instructions à l'écran
3. Entrez votre mot de passe administrateur si demandé

### Étape 4 : Vérifier l'Installation
Le plugin sera installé dans :
```
/Library/Audio/Plug-Ins/Components/mdaTalkbox.component
```

Pour vérifier :
```bash
ls -lh /Library/Audio/Plug-Ins/Components/mdaTalkbox.component
```

---

## 🎵 Utilisation dans votre DAW

### Logic Pro

1. **Ouvrez Logic Pro**
2. **Créez ou ouvrez un projet**
3. **Sur une piste audio :**
   - Cliquez sur un slot d'insert
   - Naviguez vers : **Audio Units** > **mda** > **mdaTalkbox**
4. **Configuration :**
   - **Side Chain :** Activez le side-chain pour router le signal modulateur
   - **Input 1 (Modulator) :** Votre voix
   - **Input 2 (Carrier) :** Un synthé riche en harmoniques

### Ableton Live

1. **Ouvrez Ableton Live**
2. **Dans la vue Audio Effects :**
   - Cherchez "mdaTalkbox" dans les AudioUnit
   - Glissez-déposez sur une piste

### Autres DAW

Le plugin apparaîtra dans la section **AudioUnit** (AU) de votre DAW.

---

## ⚙️ Paramètres du Plugin

| Paramètre | Description | Valeur recommandée |
|-----------|-------------|-------------------|
| **Wet** | Niveau du signal traité | 50-100% |
| **Dry** | Niveau du signal original | 0-20% |
| **Quality** | Qualité de l'analyse LPC | 80-100% |
| **Swap** | Inverse modulator/carrier | Off (sauf cas spéciaux) |

### Conseils d'Utilisation

**Pour un effet Talkbox classique :**
- Modulateur : Voix parlée ou chantée
- Carrier : Synthé avec beaucoup d'harmoniques (saw wave, square)
- Quality : 100%
- Wet : 70-100%
- Dry : 0%

**Pour un effet Vocoder :**
- Modulateur : Voix
- Carrier : Pads synthétiques
- Quality : 90%
- Wet : 80%
- Dry : 10-20%

---

## 🔍 Dépannage

### Le plugin n'apparaît pas dans ma DAW

**Solution 1 : Effacer les caches**
```bash
# Dans le Terminal :
killall -9 AudioComponentRegistrar
rm -rf ~/Library/Caches/AudioUnitCache
rm -rf ~/Library/Caches/com.apple.audiounits.cache
```

**Solution 2 : Rescanner les plugins**
- Logic Pro : **Logic Pro** > **Préférences** > **Plug-in Manager** > **Reset & Rescan**
- Ableton : **Préférences** > **Plug-ins** > **Rescan**

**Solution 3 : Vérifier l'installation**
```bash
# Valider le plugin AudioUnit
auval -v aufx talk mda*
```

### Le plugin se charge mais pas de son

1. **Vérifiez le routing :**
   - Input 1 doit recevoir le modulateur (voix)
   - Input 2 doit recevoir le carrier (synthé)

2. **Vérifiez les paramètres :**
   - Wet doit être > 0%
   - Quality doit être > 10%

3. **Testez le carrier seul :**
   - Mettez Swap sur On pour vérifier que le carrier passe

### Le son grésille ou craque

1. **Augmentez le buffer audio** de votre DAW
2. **Baissez Quality** à 70-80%
3. **Vérifiez que le sample rate** est 44.1kHz ou 48kHz

---

## 🖥️ Compatibilité

### Systèmes supportés
- ✅ macOS 11.0 Big Sur ou supérieur
- ✅ macOS 12 Monterey
- ✅ macOS 13 Ventura
- ✅ macOS 14 Sonoma
- ✅ macOS 15 Sequoia

### Processeurs supportés
- ✅ Apple Silicon (M1, M1 Pro, M1 Max, M1 Ultra)
- ✅ Apple Silicon (M2, M2 Pro, M2 Max, M2 Ultra)
- ✅ Apple Silicon (M3, M3 Pro, M3 Max)
- ✅ Intel (x86_64) - Universal Binary

### DAW testées
- ✅ Logic Pro X / Logic Pro 11
- ✅ Ableton Live 11/12
- ✅ Cubase/Nuendo
- ✅ Studio One
- ✅ Reaper
- ✅ GarageBand

---

## 🗑️ Désinstallation

Pour supprimer le plugin :

```bash
sudo rm -rf /Library/Audio/Plug-Ins/Components/mdaTalkbox.component
```

Puis effacez les caches :
```bash
killall -9 AudioComponentRegistrar
rm -rf ~/Library/Caches/AudioUnitCache
```

---

## 📚 Informations Techniques

### Corrections Apple Silicon

Cette version inclut 4 corrections critiques pour Apple Silicon :

1. **Initialisation des tableaux LPC** - Correction principale éliminant le son étouffé
2. **Protection débordement mémoire** - Sécurité accrue
3. **Synchronisation décimation** - Stabilité améliorée
4. **Initialisation fenêtre Hanning** - Prévention des crépitements

Pour plus de détails techniques, consultez `DEBUG_SESSION_REPORT.md` fourni avec le package.

### Spécifications
- **Format :** AudioUnit v2 (Component)
- **Type :** Effect
- **Latence :** ~16ms @ 48kHz
- **Traitement :** Real-time LPC Vocoder
- **Ordre LPC :** 4-50 (selon paramètre Quality)

---

## 📞 Support

### Problèmes connus
- Le plugin nécessite **deux sources audio** (modulateur + carrier)
- Certaines DAW requièrent une configuration manuelle du side-chain

### Ressources
- Documentation technique : `DEBUG_SESSION_REPORT.md`
- Scripts de compilation : `build.sh`, `create_installer.sh`
- Résumé des corrections : `CORRECTIONS_RESUMÉ.txt`

---

## 📄 Licence

mda Talkbox est un plugin open-source.
Cette version a été optimisée pour Apple Silicon en décembre 2025.

**Version :** 1.0.1
**Date :** Décembre 2025
**Compatibilité :** macOS 11.0+, Universal Binary (ARM64 + x86_64)

---

**Bon usage du plugin ! 🎵✨**
